<?php
/*
Template Name: Blog: Vertical Loop
*/
?>
<?php get_header(); ?>
<?php

$hudson_edge_options = hudson_edge_return_global_options();
$hudson_edge_id = hudson_edge_get_page_id();
$hudson_edge_sidebar = hudson_edge_get_sidebar_layout();

if(get_post_meta($hudson_edge_id, "edgt_page_background_color", true) != ""){
    $hudson_edge_background_color = 'background-color: '.esc_attr(get_post_meta($hudson_edge_id, "edgt_page_background_color", true));
}else{
    $hudson_edge_background_color = "";
}

$hudson_edge_content_style = "";
if(get_post_meta($hudson_edge_id, "edgt_content-top-padding", true) != ""){
    if(get_post_meta($hudson_edge_id, "edgt_content-top-padding-mobile", true) == 'yes'){
        $hudson_edge_content_style = "padding-top:".esc_attr(get_post_meta($hudson_edge_id, "edgt_content-top-padding", true))."px !important";
    }else{
        $hudson_edge_content_style = "padding-top:".esc_attr(get_post_meta($hudson_edge_id, "edgt_content-top-padding", true))."px";
    }
}

if(isset($hudson_edge_options['blog_vertical_loop_type_number_of_chars']) && $hudson_edge_options['blog_vertical_loop_type_number_of_chars'] != "") {
    hudson_edge_set_blog_word_count(esc_attr($hudson_edge_options['blog_vertical_loop_type_number_of_chars']));
}

?>

    <div class="full_width blog_vertical_loop" <?php hudson_edge_inline_style($hudson_edge_background_color); ?>>
        <div class="full_width_inner" <?php hudson_edge_inline_style($hudson_edge_content_style); ?>>
            <div class="blog_holder blog_vertical_loop_type">
                    <?php get_template_part('templates/blog/blog_vertical', 'loop'); ?>
            </div>
        </div>
    </div>

<?php get_footer(); ?>